﻿#include <sourcemod>
#include <sdktools_functions>
#include <sdktools_stringtables>

new Handle:wS = INVALID_HANDLE,
	Handle:wS_RegenTimer[MAXPLAYERS+1],
	bool:wS_VIPaccess[MAXPLAYERS+1],
	String:wS_VIPskinRED[MAXPLAYERS+1][75],
	String:wS_VIPskinBLU[MAXPLAYERS+1][75],
	wS_VIPmyHP[MAXPLAYERS+1],
	wS_VIPreHP[MAXPLAYERS+1],
	bool:wS_VIPpause[MAXPLAYERS+1],
	wS_VIPsayNUM[MAXPLAYERS+1];

public Plugin:myinfo = 
{
	name = "wS_Vip_Players",
	author = "wS (Schmidt)",
	description = "Преимущество в игре у VIP игроков",
	version = "1.1",
	url = "http://my-servak.ru/"
};

public OnPluginStart()
{
	wS_LoadGroup();
	LoadTranslations("wS_Vip_Players.phrases");
	RegServerCmd("wS_DownLoad", wS_DownLoad);
	RegConsoleCmd("vip", wS_SayVIP);
	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i)) wS_CheckVIPAccess(i);
	}
	HookEvent("player_spawn", wS_Player_Spawn);
	HookEvent("player_hurt", wS_Player_Hurt);
}

public OnMapStart()
{
	wS_LoadGroup();
	if (!FileExists("cfg/wS_Vip_Players/wS_Download.cfg"))
	{
		LogMessage("cfg/wS_Vip_Players/wS_Download.cfg NOT FOUND");
	}
	else ServerCommand("exec wS_Vip_Players/wS_Download.cfg");
}

wS_LoadGroup()
{
	if (wS != INVALID_HANDLE) CloseHandle(wS);
	wS = CreateKeyValues("wS_Vip_Players");
	if (!FileToKeyValues(wS, "cfg/wS_Vip_Players/wS_Vip_Players.txt"))
	{
		SetFailState("cfg/wS_Vip_Players/wS_Vip_Players.txt ERROR");
	}
}

public OnClientPutInServer(i)
{
	wS_CheckVIPAccess(i);
}

wS_CheckVIPAccess(i)
{
	decl String:wS_f[25];
	GetClientAuthString(i, wS_f, sizeof(wS_f));
	if (StrEqual(wS_f, "BOT", false))
	{
		wS_VIPaccess[i] = false;
		return;
	}
	if (!KvJumpToKey(wS, wS_f))
	{
		GetClientIP(i, wS_f, sizeof(wS_f));
		if (!KvJumpToKey(wS, wS_f))
		{
			wS_VIPaccess[i] = false;
			return;
		}
	}
	wS_VIPaccess[i] = true;
	wS_VIPpause[i] = false;
	decl wS_hp;
	if (0 < (wS_hp = KvGetNum(wS, "vip_rehp")) < 100) wS_VIPreHP[i] = wS_hp;
	else wS_VIPreHP[i] = 0;
	if (0 < (wS_hp = KvGetNum(wS, "vip_myhp")) < 501) wS_VIPmyHP[i] = wS_hp;
	else wS_VIPmyHP[i] = 0;
	KvGetString(wS, "vip_mRed", wS_VIPskinRED[i], 75);
	KvGetString(wS, "vip_mBlu", wS_VIPskinBLU[i], 75);
	KvRewind(wS);
	Format(wS_VIPskinRED[i], 75, "%s", wS_EditSkinPath(wS_VIPskinRED[i]));
	Format(wS_VIPskinBLU[i], 75, "%s", wS_EditSkinPath(wS_VIPskinBLU[i]));
}

String:wS_EditSkinPath(String:z[75])
{
	if (StrContains(z, "models", false) == -1 || StrContains(z, ".mdl", false) == -1)
	{
		z = "0";
	}
	else
	{
		TrimString(z);
		ReplaceString(z, 75, "\\", "/");
	}
	return z;
}

public wS_Player_Spawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new i = GetClientOfUserId(GetEventInt(event, "userid"));
	wS_VIPsayNUM[i] = 0;
	if (!wS_VIPaccess[i] || wS_VIPpause[i])
	{
		return;
	}
	decl t;
	if ((t = GetClientTeam(i)) < 2)
	{
		return;
	}
	wS_StopRegen(i);
	if (wS_VIPmyHP[i] > 0) SetEntProp(i, Prop_Send, "m_iHealth", wS_VIPmyHP[i]);
	if (t == 2) wS_SetModel(i, wS_VIPskinRED[i]);
	else wS_SetModel(i, wS_VIPskinBLU[i]);
}

wS_SetModel(i, const String:z[])
{
	if (!StrEqual(z, "0"))
	{
		if (!IsModelPrecached(z)) PrecacheModel(z, true);
		SetEntityModel(i, z);
	}
}

public wS_Player_Hurt(Handle:event, const String:name[], bool:dontBroadcast)
{
	decl i;
	i = GetClientOfUserId(GetEventInt(event, "userid"));
	if (wS_VIPaccess[i] && !wS_VIPpause[i] && wS_VIPreHP[i] > 0 && wS_RegenTimer[i] == INVALID_HANDLE && GetEventInt(event, "health") > 0)
	{
		wS_RegenTimer[i] = CreateTimer(1.0, wS_RegenFunc, i);
	}
}

public Action:wS_RegenFunc(Handle:timer, any:wS_i)
{
	wS_RegenTimer[wS_i] = INVALID_HANDLE;
	if (!wS_VIPpause[wS_i] && IsPlayerAlive(wS_i))
	{
		decl wS_CurHp, wS_MaxHp;
		if (wS_VIPmyHP[wS_i] > 100) wS_MaxHp = wS_VIPmyHP[wS_i];
		else wS_MaxHp = 100;
		if ((wS_CurHp = GetEntProp(wS_i, Prop_Send, "m_iHealth")) < wS_MaxHp)
		{
			wS_CurHp += wS_VIPreHP[wS_i];
			if (wS_CurHp > wS_MaxHp) wS_CurHp = wS_MaxHp;
			SetEntProp(wS_i, Prop_Send, "m_iHealth", wS_CurHp);
			if (wS_CurHp < wS_MaxHp)
			{
				wS_RegenTimer[wS_i] = CreateTimer(1.0, wS_RegenFunc, wS_i);
			}
		}
	}
}

public OnClientDisconnect(wS_i)
{
	wS_StopRegen(wS_i);
}

wS_StopRegen(wS_i)
{
	if (wS_RegenTimer[wS_i] != INVALID_HANDLE)
	{
		KillTimer(wS_RegenTimer[wS_i]);
		wS_RegenTimer[wS_i] = INVALID_HANDLE;
	}
}

public Action:wS_DownLoad(args)
{
	if (args == 1)
	{
		decl String:wS_str[75];
		GetCmdArg(1, wS_str, sizeof(wS_str));
		TrimString(wS_str);
		AddFileToDownloadsTable(wS_str);
	}
	return Plugin_Handled;
}

public Action:wS_SayVIP(i, args)
{
	if (args > 1)
	{
		return Plugin_Handled;
	}
	if (!wS_VIPaccess[i])
	{
		ReplyToCommand(i, "\x01[ wS_Vip_Players ] %t", "no vip access");
		return Plugin_Handled;
	}
	if (wS_VIPsayNUM[i] > 2)
	{
		ReplyToCommand(i, "\x01[ wS_Vip_Players ] %t", "3 menu");
		return Plugin_Handled;
	}
	wS_VIPsayNUM[i] += 1;
	new Handle:p = CreatePanel();
	decl String:wS_f[150];
	Format(wS_f, sizeof(wS_f), "[ wS_Vip_Players ] %t\n \n", "Your access");
	DrawPanelText(p, wS_f);
	if (!StrEqual(wS_VIPskinRED[i], "0"))
	{
		Format(wS_f, sizeof(wS_f), "%t", "skin t");
		DrawPanelText(p, wS_f);
	}
	if (!StrEqual(wS_VIPskinBLU[i], "0"))
	{
		Format(wS_f, sizeof(wS_f), "%t", "skin ct");
		DrawPanelText(p, wS_f);
	}
	if (wS_VIPmyHP[i] > 0)
	{
		Format(wS_f, sizeof(wS_f), "- %d hp", wS_VIPmyHP[i]);
		DrawPanelText(p, wS_f);
	}
	if (wS_VIPreHP[i] > 0)
	{
		Format(wS_f, sizeof(wS_f), "%t", "regen hp", wS_VIPreHP[i]);
		DrawPanelText(p, wS_f);
	}
	DrawPanelText(p, " ");
	if (wS_VIPpause[i]) Format(wS_f, sizeof(wS_f), "%t", "vip off");
	else Format(wS_f, sizeof(wS_f), "%t", "vip on");
	DrawPanelItem(p, wS_f);
	Format(wS_f, sizeof(wS_f), "%t", "exit");
	DrawPanelItem(p, wS_f);
	SendPanelToClient(p, i, wS_SelectMenu, 0);
	CloseHandle(p);
	return Plugin_Handled;
}

public wS_SelectMenu(Handle:menu, MenuAction:action, i, z)
{
	if (action == MenuAction_Select && z == 1)
	{
		if (wS_VIPpause[i])
		{
			wS_VIPpause[i] = false;
			PrintToChat(i, "\x01[ wS_Vip_Players ] \x04%t", "pause end");
		}
		else
		{
			wS_VIPpause[i] = true;
			PrintToChat(i, "\x01[ wS_Vip_Players ] %t", "pause start");
		}
	}
}